/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DirectoryIterator {
    private Stack enumStack = new Stack();
    private Enumeration currentEnum;
    private int rootLength;

    public DirectoryIterator(File rootDirectory, boolean changeInto) throws IOException {
        this.rootLength = rootDirectory.isAbsolute() || changeInto ? rootDirectory.getPath().length() + 1 : 0;
        Vector filesInRoot = this.getDirectoryEntries(rootDirectory);
        this.currentEnum = filesInRoot.elements();
    }

    private Vector getDirectoryEntries(File directory) {
        Vector<File> files = new Vector<File>();
        String[] filesInDir = directory.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            int i = 0;
            while (i < length) {
                files.addElement(new File(directory, filesInDir[i]));
                ++i;
            }
        }
        return files;
    }

    public File getNextFile() {
        File nextElement = null;
        try {
            while (nextElement == null) {
                if (this.currentEnum.hasMoreElements()) {
                    File element = (File)this.currentEnum.nextElement();
                    if (element.isDirectory()) {
                        this.enumStack.push(this.currentEnum);
                        Vector files = this.getDirectoryEntries(element);
                        this.currentEnum = files.elements();
                        continue;
                    }
                    nextElement = element;
                    continue;
                }
                if (!this.enumStack.empty()) {
                    this.currentEnum = (Enumeration)this.enumStack.pop();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            nextElement = null;
        }
        return nextElement;
    }

    public static void main(String[] args) throws IOException {
        File f;
        DirectoryIterator iter = new DirectoryIterator(new File("C:\\temp\\test1"), true);
        while ((f = iter.getNextFile()) != null) {
            System.out.println("File: " + f);
        }
    }
}

