/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import java.io.File;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

public class DirectoryModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected File directory;
    protected String[] children;
    protected int rowCount;
    protected Object dirIcon;
    protected Object fileIcon;

    public DirectoryModel() {
        this.init();
    }

    public DirectoryModel(File dir) {
        this.init();
        this.directory = dir;
        this.children = dir.list();
        this.rowCount = this.children.length;
    }

    protected void init() {
        this.dirIcon = UIManager.get("FileView.directoryIcon");
        this.fileIcon = UIManager.get("FileView.fileIcon");
    }

    public void setDirectory(File dir) {
        if (dir != null) {
            this.directory = dir;
            this.children = dir.list();
            this.rowCount = this.children.length;
        } else {
            this.directory = null;
            this.children = null;
            this.rowCount = 0;
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.children != null ? this.rowCount : 0;
    }

    public int getColumnCount() {
        return this.children != null ? 3 : 0;
    }

    public Object getValueAt(int row, int column) {
        if (this.directory == null || this.children == null) {
            return null;
        }
        File fileSysEntity = new File(this.directory, this.children[row]);
        switch (column) {
            case 0: {
                return fileSysEntity.isDirectory() ? this.dirIcon : this.fileIcon;
            }
            case 1: {
                return fileSysEntity.getName();
            }
            case 2: {
                if (fileSysEntity.isDirectory()) {
                    return "--";
                }
                return new Long(fileSysEntity.length());
            }
        }
        return "";
    }

    public Object getFileOrDir(int row) {
        return new File(this.directory, this.children[row]).toString();
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Bytes";
            }
        }
        return "unknown";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return this.getValueAt(0, column).getClass();
        }
        return super.getColumnClass(column);
    }
}

