/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.UploadPanel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePartProgress
extends FilePart {
    private static final Log LOG = LogFactory.getLog(FilePartProgress.class);
    static int READ_TIMEOUT = 2700000;
    private static final byte[] FILE_NAME_BYTES = EncodingUtil.getAsciiBytes((String)"; filename=");
    protected static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    protected static final byte[] CONTENT_DISPOSITION_BYTES = EncodingUtil.getAsciiBytes((String)"Content-Disposition: form-data; name=");
    private PartSource source;
    private Object listener;
    private long offset;

    public FilePartProgress(String name, File file, Object listener, long offset) throws FileNotFoundException {
        super(name, (PartSource)new FilePartSource(name, file));
        this.listener = listener;
        this.source = new FilePartSource(name, file);
        this.offset = offset;
    }

    protected void sendData(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendData(OutputStream out)");
        UploadPanel panel = (UploadPanel)this.listener;
        if (this.lengthOfData() == 0L) {
            LOG.debug((Object)"No data to send.");
            return;
        }
        byte[] tmp = new byte[4096];
        final InputStream instream = this.source.createInputStream();
        try {
            long len = this.lengthOfData();
            int counter = 0;
            final long[] ca = new long[1];
            final long[] skipped = new long[1];
            long skip = this.offset;
            LOG.debug((Object)("Bytes to skip = " + skip + " bytes"));
            LOG.debug((Object)("Length of file to upload = " + len + "bytes"));
            if (skip == len) {
                LOG.debug((Object)("FilePartProgress: file " + super.getName() + " (" + len + " bytes) is already there,skipped."));
                instream.close();
                return;
            }
            panel.setProgressMaximum((int)(len - this.offset));
            if (skip > 0L) {
                LOG.debug((Object)("FilePartProgress: skipping " + skip + " bytes."));
                ca[0] = skip;
                do {
                    Thread rt = new Thread(new Runnable(){

                        public synchronized void run() {
                            try {
                                LOG.debug((Object)("Skip target = " + ca[0] + " bytes"));
                                long as = instream.skip(ca[0]);
                                LOG.debug((Object)("Actual bytes skipped " + as + " bytes"));
                                if (as > 0L) {
                                    skipped[0] = skipped[0] + as;
                                    ca[0] = ca[0] - as;
                                    LOG.debug((Object)("Target - Actual = " + ca[0] + " bytes"));
                                } else {
                                    LOG.debug((Object)"EOF reached while skipping!");
                                    ca[0] = -1L;
                                }
                                LOG.debug((Object)("FilePartProgress: Skipped" + as + " Bytes"));
                            }
                            catch (IOException ioe2) {
                                ca[0] = -1L;
                            }
                        }
                    }, "Skip thread");
                    rt.start();
                    try {
                        rt.join(READ_TIMEOUT * 10);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (rt.isAlive() || rt.isInterrupted()) {
                        rt.interrupt();
                        throw new IOException("FilePartProgress: Skipping timeout!");
                    }
                    if (ca[0] < 0L) continue;
                    LOG.debug((Object)(String.valueOf(ca[0]) + "bytes still left to skip"));
                    skip = ca[0];
                } while (ca[0] > 0L);
                LOG.debug((Object)"FilePartProgress: skipped required bytes");
                LOG.debug((Object)("FilePartProgress: skipped bytes = " + skipped[0]));
                LOG.debug((Object)("FilePartProgress: leftover bytes = " + skip));
            }
            LOG.debug((Object)"FilePartProgress: sending data...");
            while ((len = (long)instream.read(tmp)) >= 0L) {
                out.write(tmp, 0, (int)len);
                counter = (int)((long)counter + len);
                panel.setProgressValue(counter);
                int proc = (int)Math.round(panel.getProgressBar().getPercentComplete() * 100.0);
                panel.setProgressMsg(String.valueOf(proc) + " %");
            }
            LOG.debug((Object)("FilePartProgress: Done sending data - sent " + counter + " bytes"));
        }
        finally {
            instream.close();
        }
    }

    protected long lengthOfData() throws IOException {
        LOG.trace((Object)"enter lengthOfData()");
        if (this.offset > 0L) {
            return this.source.getLength() - this.offset;
        }
        return this.source.getLength();
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendDispositionHeader(OutputStream out)");
        String encoding = URI.LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
        out.write(CONTENT_DISPOSITION_BYTES);
        out.write(QUOTE_BYTES);
        out.write(EncodingUtil.getBytes((String)this.getName(), (String)encoding));
        out.write(QUOTE_BYTES);
        String filename = this.source.getFileName();
        LOG.trace((Object)("filename is: " + filename));
        if (filename != null) {
            LOG.trace((Object)("FILE_NAME_BYTES is: " + new String(FILE_NAME_BYTES)));
            out.write(FILE_NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(EncodingUtil.getBytes((String)filename, (String)encoding));
            out.write(QUOTE_BYTES);
        }
    }
}

