/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.ConnectionInfo;
import com.fastream.iqwfserver.FilePartProgress;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUploader {
    private List task;
    private HttpClient client = new HttpClient();
    private static final Log LOG = LogFactory.getLog(HttpUploader.class);
    public static final int UNAUTHORISED = -5001;
    public static final int NOT_FOUND = -5002;
    public static final int GENERIC_ERROR = -5003;

    public HttpUploader(List task) {
        this.task = task;
    }

    public HttpUploader() {
    }

    public static void main(String[] args) {
        try {
            int ch;
            StringBuffer buffer = new StringBuffer();
            FileInputStream fis = new FileInputStream("C:\\temp\\asdasd.txt");
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                if (ch == 65279) continue;
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            System.out.println(buffer.toString());
            String encoding = URI.LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
            System.out.println(URIUtil.encodePath((String)buffer.toString(), (String)encoding));
            System.out.println(URIUtil.encodePath((String)buffer.toString(), (String)"UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String upload(File file, String webserverURL, String uploadFolder, String fileFolder, Object listener, ConnectionInfo connInfo, long overwrite) throws Exception {
        PostMethod filePost = new PostMethod();
        String contentRangeIndicator = "?contentRangeBegin=" + overwrite;
        String statusMsg = "";
        try {
            try {
                this.client.getParams().setAuthenticationPreemptive(true);
                if (connInfo.proxyHost.length() > 0) {
                    this.client.getHostConfiguration().setProxy(connInfo.proxyHost, connInfo.proxyPort);
                    if (connInfo.proxyUser.length() > 0) {
                        this.client.getState().setProxyCredentials(new AuthScope(connInfo.proxyHost, connInfo.proxyPort, null), (Credentials)new UsernamePasswordCredentials(connInfo.proxyUser, connInfo.proxyPassword));
                    }
                }
                if (connInfo.authUser.length() > 0) {
                    URL url = new URL(webserverURL);
                    ArrayList<String> authPrefs = new ArrayList<String>(2);
                    authPrefs.add("Basic");
                    authPrefs.add("Digest");
                    this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(connInfo.authUser, connInfo.authPassword);
                    this.client.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
                }
                this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
                LOG.debug((Object)"Uploading file....");
                HttpMethodRetryHandler myretryhandler = new HttpMethodRetryHandler(){

                    public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                        if (executionCount >= 0) {
                            return false;
                        }
                        if (exception instanceof NoHttpResponseException) {
                            return false;
                        }
                        return !method.isRequestSent();
                    }
                };
                String encoding = URI.LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
                filePost = new PostMethod(String.valueOf(webserverURL) + URIUtil.encodePath((String)uploadFolder, (String)encoding) + URIUtil.encodePath((String)fileFolder, (String)encoding) + contentRangeIndicator + "&silent=true");
                filePost.setRequestHeader("Connection", "keep-alive");
                LOG.debug((Object)("Uploading " + file.getName() + " to " + filePost.getURI()));
                LOG.debug((Object)"----------------");
                LOG.debug((Object)System.getProperty("file.encoding"));
                LOG.debug((Object)new String(EncodingUtil.getBytes((String)file.getName(), (String)"ISO-8859-9"), "ISO-8859-9"));
                LOG.debug((Object)"----------------");
                Part[] parts = new Part[]{new FilePartProgress(new String(EncodingUtil.getBytes((String)file.getName(), (String)encoding), encoding), file, listener, overwrite)};
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                this.task.add(filePost);
                int status = this.client.executeMethod((HttpMethod)filePost);
                this.task.clear();
                if (status == 200) {
                    statusMsg = filePost.getResponseBodyAsString();
                    String errCode = statusMsg.substring(0, 3);
                    statusMsg = statusMsg.substring(4, statusMsg.length());
                    if (errCode.equals("500")) {
                        throw new Exception("No Upload Rights under " + webserverURL + uploadFolder + fileFolder);
                    }
                    LOG.debug((Object)("Uploaded " + file + "- response=" + statusMsg));
                } else {
                    statusMsg = "Upload failed, for " + file + " - response=" + HttpStatus.getStatusText((int)status);
                    LOG.debug((Object)statusMsg);
                }
            }
            catch (SocketException ex) {
                LOG.debug((Object)("Error: " + ex.getMessage()));
                ex.printStackTrace();
                statusMsg = ex.getMessage();
                throw new Exception("No Upload Rights under " + webserverURL + uploadFolder + fileFolder);
            }
            catch (NoHttpResponseException ex) {
                LOG.debug((Object)("Error: " + ex.getMessage()));
                ex.printStackTrace();
                statusMsg = ex.getMessage();
                throw new Exception("Server is temporarily busy - Please retry later");
            }
            catch (Exception ex) {
                LOG.debug((Object)("Exception occured: " + ex.getMessage()));
                throw ex;
            }
        }
        finally {
            if (filePost != null) {
                filePost.releaseConnection();
            }
            this.task.clear();
        }
        return statusMsg;
    }

    public String makeFolder(String webserverURL, String uploadFolder, String createFolder, ConnectionInfo connInfo) throws Exception {
        GetMethod filePost = new GetMethod();
        HeadMethod head = new HeadMethod();
        String statusMsg = "";
        try {
            try {
                this.client.getParams().setAuthenticationPreemptive(true);
                if (connInfo.proxyHost.length() > 0) {
                    this.client.getHostConfiguration().setProxy(connInfo.proxyHost, connInfo.proxyPort);
                    if (connInfo.proxyUser.length() > 0) {
                        this.client.getState().setProxyCredentials(new AuthScope(connInfo.proxyHost, connInfo.proxyPort, null), (Credentials)new UsernamePasswordCredentials(connInfo.proxyUser, connInfo.proxyPassword));
                    }
                }
                if (connInfo.authUser.length() > 0) {
                    URL url = new URL(webserverURL);
                    ArrayList<String> authPrefs = new ArrayList<String>(2);
                    authPrefs.add("Basic");
                    authPrefs.add("Digest");
                    this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(connInfo.authUser, connInfo.authPassword);
                    this.client.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
                }
                this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
                LOG.debug((Object)("Creating folder " + createFolder + " at " + webserverURL + uploadFolder));
                String encoding = URI.LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
                String headCommand = String.valueOf(webserverURL) + URIUtil.encodePath((String)uploadFolder, (String)encoding) + URIUtil.encodePath((String)createFolder, (String)encoding);
                head = new HeadMethod(headCommand);
                head.setRequestHeader("Connection", "keep-alive");
                this.task.add(head);
                int status = this.client.executeMethod((HttpMethod)head);
                this.task.clear();
                if (status == 200 || status == 403) {
                    statusMsg = "Folder exists, skipping creation...";
                    LOG.debug((Object)(String.valueOf(statusMsg) + " " + createFolder + "- response=" + status));
                } else {
                    StringTokenizer st = new StringTokenizer(createFolder, "/");
                    String pathSoFar = "";
                    while (st.hasMoreElements()) {
                        pathSoFar = String.valueOf(pathSoFar) + st.nextToken() + "/";
                        LOG.debug((Object)("Creating remote folder: " + pathSoFar));
                        String folderCreationURL = String.valueOf(webserverURL) + URIUtil.encodePath((String)uploadFolder, (String)encoding) + "/?command=mkdir&filename=" + URIUtil.encodeQuery((String)pathSoFar, (String)"UTF-8") + "&silent=true";
                        filePost = new GetMethod(folderCreationURL);
                        filePost.setRequestHeader("Connection", "keep-alive");
                        LOG.debug((Object)("Folder create command is: " + folderCreationURL));
                        this.task.add(filePost);
                        status = this.client.executeMethod((HttpMethod)filePost);
                        this.task.clear();
                        statusMsg = filePost.getResponseBodyAsString();
                        if (status == 200) {
                            String errCode = statusMsg.substring(0, 3);
                            statusMsg = statusMsg.substring(4, statusMsg.length());
                            LOG.debug((Object)("Create Folder returned OK for" + uploadFolder + " - responseMsg=" + statusMsg + ";code=" + errCode));
                            continue;
                        }
                        statusMsg = "Create folder failed, for " + uploadFolder + " - response=" + statusMsg;
                        LOG.debug((Object)statusMsg);
                    }
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)("Error: " + ex.getMessage()));
                ex.printStackTrace();
                statusMsg = ex.getMessage();
                throw ex;
            }
        }
        finally {
            if (filePost != null) {
                filePost.releaseConnection();
            }
            if (head != null) {
                head.releaseConnection();
            }
            this.task.clear();
        }
        return statusMsg;
    }

    public long exists(File file, String webserverURL, String uploadFolder, String fileFolder, ConnectionInfo connInfo) throws Exception {
        HeadMethod head = new HeadMethod();
        String statusMsg = "";
        long contentLength = -2L;
        try {
            try {
                this.client.getParams().setAuthenticationPreemptive(true);
                if (connInfo.proxyHost.length() > 0) {
                    this.client.getHostConfiguration().setProxy(connInfo.proxyHost, connInfo.proxyPort);
                    if (connInfo.proxyUser.length() > 0) {
                        this.client.getState().setProxyCredentials(new AuthScope(connInfo.proxyHost, connInfo.proxyPort, null), (Credentials)new UsernamePasswordCredentials(connInfo.proxyUser, connInfo.proxyPassword));
                    }
                }
                if (connInfo.authUser.length() > 0) {
                    URL url = new URL(webserverURL);
                    ArrayList<String> authPrefs = new ArrayList<String>(2);
                    authPrefs.add("Basic");
                    authPrefs.add("Digest");
                    this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                    UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(connInfo.authUser, connInfo.authPassword);
                    this.client.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
                }
                this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
                LOG.debug((Object)("Finding if file " + file + " exists at" + webserverURL + uploadFolder + fileFolder));
                String encoding = URI.LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
                String headCommand = String.valueOf(webserverURL) + URIUtil.encodePath((String)uploadFolder, (String)encoding) + URIUtil.encodePath((String)fileFolder, (String)encoding) + URIUtil.encodePath((String)file.getName(), (String)encoding);
                head = new HeadMethod(headCommand);
                head.setRequestHeader("Connection", "keep-alive");
                LOG.debug((Object)("HttpUploader:exists(): head command is = " + headCommand));
                this.task.add(head);
                int status = this.client.executeMethod((HttpMethod)head);
                this.task.clear();
                if (status == 200) {
                    statusMsg = "HttpUploader:exists(): File exists...";
                    LOG.debug((Object)(String.valueOf(statusMsg) + ": " + file + "- response=" + status));
                    contentLength = head.getResponseContentLength();
                    LOG.debug((Object)(String.valueOf(statusMsg) + ": " + file + "- response=" + head.getResponseBodyAsString() + ", content-length=" + contentLength));
                } else if (status == 401) {
                    statusMsg = "HttpUploader:exists(): Authorisation Error";
                    LOG.debug((Object)(String.valueOf(statusMsg) + ": " + file + "- response=" + status));
                    contentLength = -5001L;
                } else if (status == 404) {
                    statusMsg = "HttpUploader:exists(): Not found";
                    statusMsg = "HEAD, for " + file + " - response=" + HttpStatus.getStatusText((int)status);
                    LOG.debug((Object)statusMsg);
                    contentLength = -5002L;
                } else {
                    statusMsg = "HttpUploader:exists(): generic error";
                    statusMsg = "HEAD, for " + file + " - response=" + status + "/" + HttpStatus.getStatusText((int)status);
                    LOG.debug((Object)statusMsg);
                    contentLength = -5003L;
                }
            }
            catch (Exception ex) {
                statusMsg = "HttpUploader:exists - Exception occurred" + ex.getMessage();
                LOG.debug((Object)statusMsg);
                throw ex;
            }
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
            this.task.clear();
        }
        return contentLength;
    }

    public String URLEncode(String s) {
        StringBuffer result = new StringBuffer("");
        Pattern pattern = Pattern.compile("[a-zA-Z0-9]");
        int j = 0;
        while (j < s.length()) {
            Matcher matcher = pattern.matcher(new String("" + s.charAt(j)));
            if (matcher.find()) {
                result.append(matcher.group());
            } else {
                result.append(String.valueOf('%') + Integer.toHexString(s.charAt(j)));
            }
            ++j;
        }
        return result.toString();
    }
}

