/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.AuthDialog;
import com.fastream.iqwfserver.ConnectionInfo;
import com.fastream.iqwfserver.DirectoryIterator;
import com.fastream.iqwfserver.HttpUploader;
import com.fastream.iqwfserver.ResumeDialog;
import com.fastream.iqwfserver.SwingWorker;
import com.fastream.iqwfserver.UploadListModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadPanel
extends JPanel
implements TableModelListener {
    private static final Log LOG = LogFactory.getLog(UploadPanel.class);
    private static final int OVERWRITE_COMPLETE = -7000;
    private static final int OVERWRITE_INCOMPLETE = -7001;
    private static final int RESUME_INCOMPLETE = -7002;
    private static final int SKIP_INCOMPLETE = -7003;
    private static final int SKIP_COMPLETE = -7004;
    JProgressBar progressBar = new JProgressBar();
    JProgressBar overallProgressBar = new JProgressBar();
    static int NUMLOOPS = 100;
    JLabel statusField = new JLabel("Ready", 2);
    JLabel progressField = new JLabel("", 4);
    SwingWorker worker;
    JButton uploadButton;
    JButton cancelButton;
    JButton loadQueueButton;
    JButton saveQueueButton;
    JTable uploadList;
    UploadListModel uploadListModel;
    String remoteHost;
    String uploadFolder;
    private ConnectionInfo connectionInfo = null;
    Border spaceBelow = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    ActionListener startListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            UploadPanel.this.uploadButton.setEnabled(false);
            UploadPanel.this.saveQueueButton.setEnabled(false);
            UploadPanel.this.loadQueueButton.setEnabled(false);
            UploadPanel.this.cancelButton.setEnabled(true);
            UploadPanel.this.statusField.setText("Uploading...");
            UploadPanel.this.worker = new SwingWorker(){

                public Object construct() {
                    return UploadPanel.this.upload();
                }

                public void finished() {
                    if ((this).UploadPanel.this.uploadListModel.getRowCount() == 0) {
                        (this).UploadPanel.this.uploadButton.setEnabled(false);
                        (this).UploadPanel.this.saveQueueButton.setEnabled(true);
                    } else {
                        (this).UploadPanel.this.uploadButton.setEnabled(true);
                        (this).UploadPanel.this.saveQueueButton.setEnabled(true);
                    }
                    (this).UploadPanel.this.loadQueueButton.setEnabled(true);
                    (this).UploadPanel.this.cancelButton.setEnabled(false);
                    (this).UploadPanel.this.statusField.setText(this.get().toString());
                    (this).UploadPanel.this.progressField.setText("");
                    (this).UploadPanel.this.progressBar.setMaximum(0);
                    (this).UploadPanel.this.progressBar.setValue(0);
                    (this).UploadPanel.this.overallProgressBar.setMaximum(0);
                    (this).UploadPanel.this.overallProgressBar.setValue(0);
                }
            };
            UploadPanel.this.worker.start();
        }
    };
    ActionListener interruptListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            LOG.debug((Object)"Cancel button pressed!");
            UploadPanel.this.cancelButton.setEnabled(false);
            UploadPanel.this.worker.interrupt();
            if (UploadPanel.this.uploadListModel.getRowCount() != 0) {
                UploadPanel.this.uploadButton.setEnabled(true);
                UploadPanel.this.saveQueueButton.setEnabled(true);
            }
            UploadPanel.this.loadQueueButton.setEnabled(true);
        }
    };
    ActionListener loadQueueListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            LOG.debug((Object)"Load button pressed!");
            JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
            fc.addChoosableFileFilter(new QueueFilter());
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(UploadPanel.this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                boolean result = UploadPanel.this.uploadListModel.loadQueue(file);
                if (!result) {
                    UploadPanel.this.setStatusMsg("Could not load queue file!");
                } else {
                    UploadPanel.this.setStatusMsg("Queue file Loaded");
                }
            } else {
                LOG.debug((Object)"Open command cancelled by user.");
            }
        }
    };
    ActionListener saveQueueListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            LOG.debug((Object)"Save button pressed!");
            boolean result = UploadPanel.this.uploadListModel.saveQueue(UploadPanel.this.remoteHost);
            if (!result) {
                UploadPanel.this.setStatusMsg("Could not save queue file!");
            } else {
                UploadPanel.this.setStatusMsg("Queue file Saved");
            }
        }
    };

    JButton getUploadButton() {
        return this.uploadButton;
    }

    public void setProgressMsg(final String msg) {
        Runnable doSetProgressMsg = new Runnable(){

            public void run() {
                UploadPanel.this.progressField.setText(msg);
            }
        };
        SwingUtilities.invokeLater(doSetProgressMsg);
    }

    public void setStatusMsg(final String msg) {
        Runnable doSetProgressMsg = new Runnable(){

            public void run() {
                UploadPanel.this.statusField.setText(msg);
            }
        };
        SwingUtilities.invokeLater(doSetProgressMsg);
    }

    public void setProgressValue(final int value) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                UploadPanel.this.progressBar.setValue(value);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void setOverallProgressValue(final int value) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                UploadPanel.this.overallProgressBar.setValue(value);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void setProgressMaximum(final int value) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                UploadPanel.this.progressBar.setMaximum(value);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void setOverallProgressMaximum(final int value) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                UploadPanel.this.overallProgressBar.setMaximum(value);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    void updateStatus(final int i) {
        Runnable doSetProgressBarValue = new Runnable(){

            public void run() {
                UploadPanel.this.progressBar.setValue(i);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public List processSubdirectories2(File aStartingDir) throws FileNotFoundException {
        UploadPanel.validateDirectory(aStartingDir);
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        Iterator<File> filesIter = filesDirs.iterator();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            result.add(file);
            if (file.isFile()) continue;
            List deeperList = this.processSubdirectories(file);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public List processSubdirectories(File aStartingDir) throws FileNotFoundException {
        UploadPanel.LOG.debug((Object)("processSubdirectories(): Got aStartingDir = " + aStartingDir));
        UploadPanel.validateDirectory(aStartingDir);
        result = new ArrayList<File>();
        try {
            iter = new DirectoryIterator(aStartingDir, true);
            if (true) ** GOTO lbl14
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FileNotFoundException(e.getMessage());
        }
        do {
            UploadPanel.LOG.debug((Object)("processSubdirectories(): Got aStartingDir = " + aStartingDir));
            result.add(f);
lbl14:
            // 2 sources

        } while ((f = iter.getNextFile()) != null);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    void showAuthFailedDialog(String file) throws InterruptedException {
        private class DoShowDialog
        implements Runnable {
            String file;

            public DoShowDialog(String file) {
                this.file = file;
            }

            public void run() {
                Object[] options = new Object[]{"OK"};
                JOptionPane.showOptionDialog(UploadPanel.this, "Authentication failed for " + this.file + ", skipping...", "Authentication Failed", 0, 3, null, options, "OK");
            }
        }
        DoShowDialog doShowDialog = new DoShowDialog(file);
        try {
            SwingUtilities.invokeAndWait(doShowDialog);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            LOG.debug((Object)"Exception in UploadPanel:showAuthFailedDialog");
        }
    }

    Map showAuthDialog() throws InterruptedException {
        private class DoShowDialog
        implements Runnable {
            public int result;
            public String username = "";
            public String password = "";

            public void run() {
                AuthDialog auth = new AuthDialog(UploadPanel.this.findParent(), true);
                auth.show();
                this.result = auth.result;
                this.password = auth.getPassword();
                this.username = auth.getUsername();
            }
        }
        DoShowDialog doShowDialog = new DoShowDialog();
        try {
            SwingUtilities.invokeAndWait(doShowDialog);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            LOG.debug((Object)"Exception in showAuthDialog()");
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("result", new Integer(doShowDialog.result));
        result.put("username", doShowDialog.username);
        result.put("password", doShowDialog.password);
        return result;
    }

    int showResumeDialog(String file, boolean resume) throws InterruptedException {
        private class DoShowDialog
        implements Runnable {
            int result;
            String file;
            boolean resume;

            public DoShowDialog(String file, boolean resume) {
                this.file = file;
                this.resume = resume;
            }

            public void run() {
                ResumeDialog resumeDialog = new ResumeDialog(UploadPanel.this.findParent(), this.file, this.resume);
                resumeDialog.show();
                this.result = resumeDialog.result;
            }
        }
        DoShowDialog doShowDialog = new DoShowDialog(file, resume);
        try {
            SwingUtilities.invokeAndWait(doShowDialog);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            LOG.debug((Object)"Exception in UploadPanel:showResumeDialog");
        }
        return doShowDialog.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object upload() {
        Object ex = null;
        Thread t = null;
        final List task = Collections.synchronizedList(new ArrayList());
        final StringBuffer exMsg = new StringBuffer();
        try {
            t = new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        HttpUploader uploader = new HttpUploader(task);
                        Hashtable dirsToUpload = null;
                        int numFiles = 0;
                        ArrayList<String> rootFiles = null;
                        int incompleteAction = 0;
                        int completeAction = 0;
                        if (UploadPanel.this.uploadListModel.uploadDirectories != null) {
                            dirsToUpload = UploadPanel.this.uploadListModel.uploadDirectories;
                            numFiles = UploadPanel.this.uploadListModel.totalFiles;
                            if (dirsToUpload.containsKey("root")) {
                                dirsToUpload.remove("root");
                            }
                        } else {
                            UploadPanel.this.uploadListModel.uploadDirectories = dirsToUpload = new Hashtable();
                        }
                        String[] files = UploadPanel.this.uploadListModel.getAllItems();
                        LOG.debug((Object)("upload(): total original files are= " + files.length));
                        int i = 0;
                        while (i < files.length) {
                            LOG.debug((Object)("Iteration: " + i));
                            File testFileSysEntity = new File(files[i]);
                            LOG.debug((Object)("Processing entity: " + testFileSysEntity));
                            if (testFileSysEntity.isDirectory()) {
                                LOG.debug((Object)("Found directory: " + testFileSysEntity));
                                if (!dirsToUpload.containsKey(testFileSysEntity.toString())) {
                                    List subdirectories = UploadPanel.this.processSubdirectories(testFileSysEntity);
                                    numFiles += subdirectories.size();
                                    dirsToUpload.put(testFileSysEntity.toString(), subdirectories);
                                }
                            } else {
                                if (rootFiles == null) {
                                    rootFiles = new ArrayList<String>();
                                    dirsToUpload.put("root", rootFiles);
                                }
                                LOG.debug((Object)("Found file: " + testFileSysEntity + ", adding to dirsToUpload"));
                                rootFiles.add(files[i]);
                                ++numFiles;
                            }
                            ++i;
                        }
                        UploadPanel.this.uploadListModel.totalFiles = numFiles;
                        LOG.debug((Object)("Setting max limit for progress for overall progress bar: " + numFiles));
                        UploadPanel.this.setOverallProgressMaximum(numFiles);
                        LOG.debug((Object)("overallProgressBar.getMaximum() is now: " + UploadPanel.this.overallProgressBar.getMaximum()));
                        Enumeration keys = dirsToUpload.keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            List lst = (List)dirsToUpload.get(key);
                            int listSize = lst.size();
                            LOG.debug((Object)("Total files and directories to upload for directory " + key + "are " + listSize));
                            long contentLength = 0L;
                            int fileCount = 0;
                            Iterator iterFiles = lst.iterator();
                            int i2 = 0;
                            while (i2 < listSize) {
                                block45: {
                                    String uploadPath;
                                    File f;
                                    block47: {
                                        boolean complete;
                                        block46: {
                                            LOG.debug((Object)("Setting overallProgressValue to: " + ++fileCount));
                                            UploadPanel.this.setOverallProgressValue(fileCount);
                                            UploadPanel.this.setStatusMsg("Uploading " + fileCount + "/" + numFiles);
                                            f = key.equals("root") ? new File((String)iterFiles.next()) : (File)iterFiles.next();
                                            LOG.debug((Object)("Passing directory " + key + "and file " + f.toString() + "to makeUploadFolder"));
                                            uploadPath = UploadPanel.this.makeUploadFolder(key, f.toString());
                                            contentLength = uploader.exists(f, UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this.connectionInfo);
                                            if (contentLength != -5001L) break block46;
                                            Map result = null;
                                            int j = 0;
                                            while (j < 3) {
                                                if (contentLength == -5001L) {
                                                    result = UploadPanel.this.showAuthDialog();
                                                    if (result.isEmpty()) {
                                                        LOG.debug((Object)"Error occurred in showAuthDialog()");
                                                        throw new Exception("Unexpected Error - please check logs");
                                                    }
                                                    switch ((Integer)result.get("result")) {
                                                        case -3000: {
                                                            ((UploadPanel)UploadPanel.this).connectionInfo.authUser = (String)result.get("username");
                                                            ((UploadPanel)UploadPanel.this).connectionInfo.authPassword = (String)result.get("password");
                                                            contentLength = uploader.exists(f, UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this.connectionInfo);
                                                            break;
                                                        }
                                                        case -3001: {
                                                            LOG.debug((Object)("Skipping file: " + f));
                                                            break block45;
                                                        }
                                                        case -3002: {
                                                            throw new InterruptedException("User aborted auth process.");
                                                        }
                                                    }
                                                }
                                                ++j;
                                            }
                                            if (j != 3 || contentLength != -5001L) break block46;
                                            UploadPanel.this.showAuthFailedDialog(f.toString());
                                            break block45;
                                        }
                                        if (contentLength < 0L) break block47;
                                        LOG.debug((Object)("Files Exists, ContentLength is " + contentLength + ", Size of file on disk = " + f.length()));
                                        boolean bl = complete = contentLength == f.length();
                                        if (incompleteAction == 0 && completeAction == 0 || completeAction == 0 && complete || incompleteAction == 0 && !complete) {
                                            int result = UploadPanel.this.showResumeDialog(f.toString(), contentLength != f.length());
                                            switch (result) {
                                                case -5000: {
                                                    LOG.debug((Object)"User selected Resume option");
                                                    break;
                                                }
                                                case -5003: {
                                                    LOG.debug((Object)"User selected Resume All option");
                                                    incompleteAction = -7002;
                                                    break;
                                                }
                                                case -5001: {
                                                    LOG.debug((Object)"User selected Overwrite option");
                                                    contentLength = 0L;
                                                    break;
                                                }
                                                case -5004: {
                                                    LOG.debug((Object)"User selected Overwrite All option");
                                                    if (contentLength == f.length()) {
                                                        LOG.debug((Object)"File on server is same size as local file, user wants to overwrite all complete files");
                                                        completeAction = -7000;
                                                        break;
                                                    }
                                                    LOG.debug((Object)"File on server is not the same size as local file, user wants to overwrite all incomplete files");
                                                    incompleteAction = -7001;
                                                    break;
                                                }
                                                case -5002: {
                                                    LOG.debug((Object)"User selected Skip file option");
                                                    contentLength = -1L;
                                                    break;
                                                }
                                                case -5005: {
                                                    LOG.debug((Object)"User selected Skip All option");
                                                    if (contentLength == f.length()) {
                                                        LOG.debug((Object)"File on server is same size as local file, user wants to skip all complete files");
                                                        completeAction = -7004;
                                                        break;
                                                    }
                                                    LOG.debug((Object)"File on server is not the same size as local file, user wants to skip all incomplete files");
                                                    incompleteAction = -7003;
                                                    break;
                                                }
                                            }
                                        }
                                        if (completeAction == -7004 && complete) {
                                            LOG.debug((Object)"'Skip All complete files' flag detected, skipping...");
                                            contentLength = -1L;
                                        } else if (incompleteAction == -7003 && !complete) {
                                            LOG.debug((Object)"'Skip All incomplete files' flag detected, skipping...");
                                            contentLength = -1L;
                                        }
                                        if (contentLength > -1L) {
                                            if (complete) {
                                                if (completeAction == -7000) {
                                                    LOG.debug((Object)"'Overwrite All complete files' flag detected, overwriting...");
                                                    contentLength = 0L;
                                                }
                                            } else if (completeAction == -7001) {
                                                LOG.debug((Object)"'Overwrite All incomplete files' flag detected, overwriting...");
                                                contentLength = 0L;
                                            }
                                            LOG.debug((Object)("incompleteAction != UploadPanel.RESUME_INCOMPLETE Evaluates to: " + (incompleteAction != -7002)));
                                            LOG.debug((Object)("incompleteAction == UploadPanel.RESUME_INCOMPLETE && !complete Evaluates to: " + (incompleteAction == -7002 && !complete)));
                                            if (incompleteAction != -7002 || incompleteAction == -7002 && !complete) {
                                                LOG.debug((Object)("Passing ContentLength " + contentLength + " to uploader.upload()"));
                                                uploader.makeFolder(UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this.connectionInfo);
                                                uploader.upload(f, UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this, UploadPanel.this.connectionInfo, contentLength);
                                            }
                                            if (key.equals("root")) {
                                                UploadPanel.this.uploadListModel.removeItem(f.toString());
                                            }
                                            iterFiles.remove();
                                        }
                                        break block45;
                                    }
                                    if (contentLength == -5002L) {
                                        uploader.makeFolder(UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this.connectionInfo);
                                        uploader.upload(f, UploadPanel.this.remoteHost, UploadPanel.this.uploadFolder, uploadPath, UploadPanel.this, UploadPanel.this.connectionInfo, 0L);
                                        if (key.equals("root")) {
                                            UploadPanel.this.uploadListModel.removeItem(f.toString());
                                        }
                                        iterFiles.remove();
                                    } else if (contentLength == -5003L) {
                                        throw new Exception("Unexpected Error encountered!");
                                    }
                                }
                                ++i2;
                            }
                            if (lst.size() != 0) continue;
                            UploadPanel.this.uploadListModel.removeItem(key);
                            dirsToUpload.remove(key);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exMsg.append(e.getMessage());
                        Thread.currentThread().interrupt();
                    }
                    LOG.debug((Object)"Worker thread in UploadPanel:upload() is existing...");
                }
            });
            t.start();
            t.join();
            if (this.uploadListModel.uploadDirectories.isEmpty()) {
                this.uploadListModel.uploadDirectories = null;
                this.uploadListModel.totalFiles = 0;
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"UploadPanel:upload() - InterruptedException caught...");
            e.printStackTrace();
            if (t.isAlive()) {
                LOG.debug((Object)"HttpUpload thread is still alive, interrupting...");
                t.interrupt();
            }
            List list = task;
            synchronized (list) {
                if (task.size() != 0) {
                    LOG.debug((Object)"HttpMethod still running, aborting...");
                    HttpMethod m = (HttpMethod)task.get(0);
                    m.abort();
                    LOG.debug((Object)"Aborted!");
                }
            }
            return "Interrupted";
        }
        catch (Exception e) {
            LOG.debug((Object)"UploadPanel:upload() - Exception caught...");
            e.printStackTrace();
            if (t.isAlive()) {
                LOG.debug((Object)"HttpUpload thread is still alive, interrupting...");
                t.interrupt();
            }
            List list = task;
            synchronized (list) {
                if (task.size() != 0) {
                    LOG.debug((Object)"HttpMethod still running, aborting...");
                    HttpMethod m = (HttpMethod)task.get(0);
                    m.abort();
                    LOG.debug((Object)"Aborted!");
                }
            }
            return e.getMessage();
        }
        if (exMsg.length() != 0) {
            return exMsg;
        }
        return "All Done";
    }

    UploadPanel(JTable uploadList, UploadListModel uploadListModel, String url, String uploadFolder) {
        this.uploadList = uploadList;
        this.uploadListModel = uploadListModel;
        uploadListModel.addTableModelListener(this);
        this.remoteHost = url;
        this.uploadFolder = uploadFolder;
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.loadConfig();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Upload Progress"));
        this.progressBar.setMaximum(0);
        this.overallProgressBar.setMaximum(0);
        this.uploadButton = new JButton("Upload");
        this.uploadButton.addActionListener(this.startListener);
        this.uploadButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.interruptListener);
        this.cancelButton.setEnabled(false);
        this.loadQueueButton = new JButton("Load");
        this.loadQueueButton.addActionListener(this.loadQueueListener);
        this.loadQueueButton.setEnabled(true);
        this.saveQueueButton = new JButton("Save");
        this.saveQueueButton.addActionListener(this.saveQueueListener);
        this.saveQueueButton.setEnabled(false);
        JPanel buttonBox = new JPanel();
        buttonBox.add(this.uploadButton);
        buttonBox.add(this.cancelButton);
        buttonBox.add(this.loadQueueButton);
        buttonBox.add(this.saveQueueButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(buttonBox);
        this.add(this.progressField);
        this.add(this.progressBar);
        this.add(this.overallProgressBar);
        buttonBox.setBorder(this.spaceBelow);
        Border pbBorder = this.progressBar.getBorder();
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(this.spaceBelow, pbBorder));
        this.statusField.setAlignmentX(0.0f);
        this.add(this.statusField);
        this.statusField.setHorizontalTextPosition(2);
    }

    public static void main(String[] args) {
        String laf = UIManager.getCrossPlatformLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        JFrame f = new JFrame("Upload Test");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        f.addWindowListener(l);
        Container contentPane = f.getContentPane();
        UploadPanel uploadPanel = new UploadPanel(null, null, null, null);
        contentPane.setLayout(new GridLayout(1, 0));
        contentPane.add(uploadPanel);
        f.pack();
        f.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UploadPanel.this.getUploadButton().requestFocus();
            }
        });
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private String makeUploadFolder(String d, String f) {
        if (d.equals("root")) {
            return "/";
        }
        int separatorIndex = d.lastIndexOf(File.separatorChar);
        String directory = d.substring(separatorIndex, d.length());
        LOG.debug((Object)directory);
        int startIndex = f.indexOf(directory);
        separatorIndex = f.lastIndexOf(File.separatorChar);
        String fileName = f.substring(separatorIndex + 1, f.length());
        LOG.debug((Object)fileName);
        int endIndex = f.lastIndexOf(fileName);
        String uploadFolder = f.substring(startIndex, endIndex);
        uploadFolder = uploadFolder.replace('\\', '/');
        LOG.debug((Object)uploadFolder);
        return uploadFolder;
    }

    public void tableChanged(TableModelEvent e) {
        LOG.debug((Object)("UploadPanel.tableChanged(), event type is = " + e.getType()));
        if (e.getType() == 1 || e.getType() == -1) {
            if (this.uploadListModel.getRowCount() == 0) {
                this.getUploadButton().setEnabled(false);
                this.saveQueueButton.setEnabled(false);
            } else {
                this.getUploadButton().setEnabled(true);
                this.saveQueueButton.setEnabled(true);
            }
        } else if (e.getType() == 0) {
            if (this.uploadListModel.getRowCount() == 0) {
                this.getUploadButton().setEnabled(false);
                this.saveQueueButton.setEnabled(false);
            } else {
                this.getUploadButton().setEnabled(true);
                this.saveQueueButton.setEnabled(true);
            }
        }
    }

    private Frame findParent() {
        Frame f = null;
        Container c = this;
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        f = c == null ? new Frame() : (Frame)c;
        return f;
    }

    class QueueFilter
    extends FileFilter {
        QueueFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext != null && ext.equals("iqw");
        }

        public String getDescription() {
            return "IQWFUploader queue files";
        }
    }
}

