/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance((String)"SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public boolean isClientTrusted(X509Certificate[] certificates) {
        return this.standardTrustManager.isClientTrusted(certificates);
    }

    public boolean isServerTrusted(X509Certificate[] certificates) {
        if (certificates != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Server certificate chain:");
            int i = 0;
            while (i < certificates.length) {
                LOG.debug((Object)("X509Certificate[" + i + "]=" + certificates[i]));
                ++i;
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate certificate = certificates[0];
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e) {
                LOG.error((Object)e.toString());
                return false;
            }
            return true;
        }
        return this.standardTrustManager.isServerTrusted(certificates);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

