/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.EasySSLProtocolSocketFactory;
import com.fastream.iqwfserver.FileTree;
import com.fastream.iqwfserver.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class FileExplorerApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;

    public static void main(String[] args) {
    }

    public FileExplorerApplet() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.com.fastream.iqwfserver", "trace");
        System.setProperty("httpclient.useragent", "Fastream IQ Web/FTP Server Applet");
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    FileExplorerApplet.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("createGUI didn't successfully complete");
        }
    }

    private Frame findParent() {
        Frame f = null;
        Container c = this;
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        f = c == null ? new Frame() : (Frame)c;
        return f;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private void createGUI() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        ActionListener printListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.out.println("Menu item [" + event.getActionCommand() + "] was pressed.");
                Frame f = FileExplorerApplet.this.findParent();
                OptionsDialog d = new OptionsDialog(f);
            }
        };
        JMenuItem item = new JMenuItem("Options");
        fileMenu.add(item);
        item.addActionListener(printListener);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.setSize(600, 600);
        this.setContentPane(this.getJContentPane());
        String remoteHost = this.getParameter("remoteHost");
        String uploadFolder = this.getParameter("uploadFolder");
        if (remoteHost == null || uploadFolder == null) {
            System.err.println("Missing Parameters - existing...");
            System.exit(0);
        }
        URL url = null;
        try {
            url = new URL(remoteHost);
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid remoteHost URL - existing...");
            e.printStackTrace();
            System.exit(0);
        }
        if (url.getProtocol().equals("https")) {
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), port);
            Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        }
        FileTree ft = new FileTree(this.getContentPane(), remoteHost, uploadFolder);
    }
}

