/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.DirectoryModel;
import com.fastream.iqwfserver.DirectoryRenderer;
import com.fastream.iqwfserver.DirsOnlyFilter;
import com.fastream.iqwfserver.UploadListModel;
import com.fastream.iqwfserver.UploadListRenderer;
import com.fastream.iqwfserver.UploadPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class FileTree
implements TreeWillExpandListener,
TreeSelectionListener {
    private MutableTreeNode root;
    private JTree tree;
    private JTable uploadListTable;
    private JLabel currentSelection;
    private JPopupMenu popup;
    private UploadListModel uploadListModel;
    private DirectoryModel directoryModel;
    private JTable directoryTable;
    private File currentFile;
    private File[] currentFiles;
    private boolean newFile = true;
    private static String PLACEHOLDER = "@@_jb_special_placeholder_@@";

    public FileTree(Container c, String remoteHost, String uploadFolder) {
        this.getFiles();
        this.uploadListModel = new UploadListModel();
        this.uploadListTable = new JTable(this.uploadListModel);
        this.uploadListTable.setShowHorizontalLines(false);
        this.uploadListTable.setShowVerticalLines(false);
        this.uploadListTable.setIntercellSpacing(new Dimension(0, 2));
        this.uploadListTable.setSelectionMode(0);
        this.uploadListTable.getColumn("Type").setCellRenderer(new UploadListRenderer());
        this.uploadListTable.getColumn("Type").setMaxWidth(32);
        this.uploadListTable.getColumn("Type").setMinWidth(32);
        this.uploadListTable.setBackground(Color.white);
        this.directoryModel = new DirectoryModel(new File(System.getProperty("user.home")));
        this.directoryTable = new JTable(this.directoryModel);
        this.directoryTable.setShowHorizontalLines(false);
        this.directoryTable.setShowVerticalLines(false);
        this.directoryTable.setIntercellSpacing(new Dimension(0, 2));
        this.directoryTable.setSelectionMode(2);
        this.directoryTable.getColumn("Type").setCellRenderer(new DirectoryRenderer());
        this.directoryTable.getColumn("Type").setMaxWidth(32);
        this.directoryTable.getColumn("Type").setMinWidth(32);
        JScrollPane treeScroller = new JScrollPane(this.tree);
        treeScroller.setMinimumSize(new Dimension(0, 0));
        treeScroller.setBackground(Color.white);
        treeScroller.setPreferredSize(new Dimension(290, 0));
        JScrollPane directoryTableScroller = new JScrollPane(this.directoryTable);
        directoryTableScroller.setMinimumSize(new Dimension(0, 0));
        directoryTableScroller.setBackground(Color.white);
        directoryTableScroller.setPreferredSize(new Dimension(0, 0));
        JSplitPane splitPaneHoriz = new JSplitPane(1, treeScroller, directoryTableScroller);
        splitPaneHoriz.setContinuousLayout(true);
        splitPaneHoriz.setPreferredSize(new Dimension(400, 500));
        splitPaneHoriz.setBackground(Color.white);
        JScrollPane uploadListTableScroller = new JScrollPane(this.uploadListTable);
        uploadListTableScroller.setMinimumSize(new Dimension(0, 0));
        uploadListTableScroller.setBackground(Color.white);
        JButton bt = new JButton("Add >>");
        bt.setToolTipText("Add selection to queue");
        bt.setRequestFocusEnabled(false);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int nRow = FileTree.this.uploadListTable.getSelectedRow() + 1;
                int[] dirTableSelectedRowsIndices = FileTree.this.directoryTable.getSelectedRows();
                int[] treeSelectedRowsIndices = FileTree.this.tree.getSelectionRows();
                if (dirTableSelectedRowsIndices.length == 0 && (treeSelectedRowsIndices == null || treeSelectedRowsIndices.length == 0)) {
                    return;
                }
                if (dirTableSelectedRowsIndices.length != 0 && FileTree.this.directoryTable.isFocusOwner()) {
                    int i = 0;
                    while (i < dirTableSelectedRowsIndices.length) {
                        FileTree.this.uploadListModel.addItem(nRow, (String)FileTree.this.directoryModel.getFileOrDir(dirTableSelectedRowsIndices[i]));
                        ++i;
                    }
                } else if (treeSelectedRowsIndices.length != 0 && FileTree.this.tree.isFocusOwner()) {
                    FileTree.this.uploadListModel.addItem(nRow, FileTree.this.getCurrentFile().toString());
                }
            }
        };
        bt.addActionListener(lst);
        JButton bt2 = new JButton("<< Remove");
        bt2.setToolTipText("Remove selection from queue");
        bt2.setRequestFocusEnabled(false);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int nRow = FileTree.this.uploadListTable.getSelectedRow();
                if (FileTree.this.uploadListModel.removeItem(nRow)) {
                    FileTree.this.uploadListTable.tableChanged(new TableModelEvent(FileTree.this.uploadListModel, nRow, nRow, -1, -1));
                    FileTree.this.uploadListTable.clearSelection();
                }
            }
        };
        bt2.addActionListener(lst);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(bt);
        buttonPanel.add(bt2);
        UploadPanel progressPane = new UploadPanel(this.uploadListTable, this.uploadListModel, remoteHost, uploadFolder);
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BorderLayout());
        bottomPane.add((Component)uploadListTableScroller, "Center");
        bottomPane.add((Component)progressPane, "East");
        bottomPane.add((Component)buttonPanel, "South");
        bottomPane.setPreferredSize(new Dimension(0, 0));
        bottomPane.setBackground(Color.white);
        JSplitPane splitPaneVert = new JSplitPane(0, splitPaneHoriz, bottomPane);
        splitPaneVert.setContinuousLayout(true);
        splitPaneVert.setBackground(Color.white);
        c.add((Component)splitPaneVert, "Center");
    }

    private void getFiles() {
        this.root = new DefaultMutableTreeNode("fmTopLevel");
        File[] roots = File.listRoots();
        int i = 0;
        while (i < roots.length) {
            File f = roots[i];
            String name = f.toString();
            if (name.equals("/")) {
                name = "root";
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            this.root.insert(node, this.root.getChildCount());
            if (!name.equals("A:\\")) {
                this.addDirToModel(f, node);
            }
            ++i;
        }
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.tree = new JTree(model);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.tree.setDragEnabled(false);
        this.setTree(new File(System.getProperty("user.home")), this.newFile);
    }

    public void setTree(File f, boolean newFile) {
        this.newFile = newFile;
        this.currentFile = f;
        TreePath p = FileTree.pathFromFile(f);
        int lastIndex = 0;
        int i = 1;
        while (i < p.getPathCount()) {
            TreePath thePath = this.tree.getNextMatch(p.getPathComponent(i).toString(), lastIndex, Position.Bias.Forward);
            this.tree.expandPath(thePath);
            lastIndex = this.tree.getRowForPath(thePath);
            ++i;
        }
        if (newFile) {
            this.tree.setSelectionPath(p);
        }
        this.tree.scrollPathToVisible(p);
        String msg = f.isDirectory() ? "Opened directory  " + f.toString() : "Opened file  " + f.toString();
    }

    public static File fileFromPath(TreePath p) {
        StringBuffer filePath = new StringBuffer();
        int i = 1;
        while (i < p.getPathCount()) {
            String component = p.getPathComponent(i).toString().equals("root") ? "//" : p.getPathComponent(i).toString();
            filePath.append(String.valueOf(component) + File.separator);
            ++i;
        }
        return new File(filePath.toString());
    }

    public static TreePath pathFromFile(File f) {
        String str = f.toString();
        ArrayList nodeStringsList = new ArrayList();
        if (str.equals("/")) {
            Object[] nodes = new Object[]{new DefaultMutableTreeNode("fmTopLevel"), new DefaultMutableTreeNode("root")};
            return new TreePath(nodes);
        }
        ArrayList<Object> nodeList = new ArrayList<Object>();
        nodeList.add(new DefaultMutableTreeNode("fmTopLevel"));
        String safeSeparator = File.separator.equals("\\") ? "\\\\" : File.separator;
        String[] temp = f.toString().split(safeSeparator);
        int i = 0;
        while (i < temp.length) {
            String t = temp[i];
            if (t.endsWith(":") && System.getProperty("os.name").indexOf("Windows") > -1) {
                t = String.valueOf(t) + "\\";
            }
            nodeList.add(new DefaultMutableTreeNode(t));
            ++i;
        }
        if (File.separator.equals("/")) {
            nodeList.set(1, "root");
        }
        Object[] nodes = nodeList.toArray();
        return new TreePath(nodes);
    }

    public void setTree(TreePath p, boolean newFile) {
        this.setTree(FileTree.fileFromPath(p), newFile);
    }

    public void refreshTree() {
        TreePath[] allPaths = this.tree.getSelectionPaths();
        int i = 0;
        while (i < allPaths.length) {
            this.setTree(allPaths[i], false);
            ++i;
        }
    }

    private void addDirToModel(File f, MutableTreeNode n) {
        Object[] contents = f.listFiles(new DirsOnlyFilter(false));
        if (contents != null) {
            Arrays.sort(contents);
        }
        try {
            int i = 0;
            while (i < contents.length) {
                Object t = contents[i];
                String name = ((File)t).getName();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
                n.insert(node, n.getChildCount());
                if (this.containsDirs((File)t)) {
                    node.insert(new DefaultMutableTreeNode(PLACEHOLDER), 0);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("addDirToModel exception: " + e);
        }
    }

    private boolean containsDirs(File f) {
        if (!f.canRead()) {
            return false;
        }
        return f.listFiles(new DirsOnlyFilter(true)).length > 0;
    }

    public File[] getSelectedFiles() {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        File[] fileBuffer = new File[selectedPaths.length];
        int i = 0;
        while (i < selectedPaths.length) {
            fileBuffer[i] = FileTree.fileFromPath(selectedPaths[i]);
            ++i;
        }
        return fileBuffer;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setSelectionPath(TreePath p) {
        System.out.println("opening " + p);
        this.tree.setSelectionPath(p);
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        MutableTreeNode node = (MutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (node.getChildAt(0).toString().equals(PLACEHOLDER)) {
            node.remove(0);
            this.addDirToModel(FileTree.fileFromPath(path), node);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath p = this.tree.getSelectionPath();
        if (p != null) {
            this.currentFile = FileTree.fileFromPath(this.tree.getSelectionPath());
            if (this.directoryModel != null) {
                this.directoryModel.setDirectory(this.currentFile);
            }
        }
    }

    public static void main(String[] args) {
    }
}

