/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.fastream.iqwfserver.ConnectionInfo;
import com.fastream.iqwfserver.DialogLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane componentPanel = null;
    private JPanel proxy = null;
    private JPanel security = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel proxyHostLbl = null;
    private JTextField proxyHostField = null;
    private JLabel proxyPortLbl = null;
    private JTextField proxyPortField = null;
    private JLabel proxyUserNameLbl = null;
    private JTextField proxyUserField = null;
    private JLabel proxyPasswordLbl = null;
    private JTextField proxyPasswordField = null;
    private JLabel userNameLbl = null;
    private JTextField userNameField = null;
    private JLabel userPasswordLbl = null;
    private JTextField userPasswordField = null;
    private ConnectionInfo connectionInfo = null;
    private boolean done = false;
    private JLabel statusMsg = null;
    private JPanel statusPanel = null;

    public OptionsDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Options");
        this.setBounds(new Rectangle(0, 0, 300, 210));
        this.setContentPane(this.getJContentPane());
        this.setResizable(false);
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.loadConfig();
        this.getProxyHostField().setText(this.connectionInfo.getProxyHost());
        this.getProxyPasswordField().setText(this.connectionInfo.getProxyPassword());
        this.getProxyPortField().setText(Integer.toString(this.connectionInfo.getProxyPort()));
        this.getProxyUserField().setText(this.connectionInfo.getProxyUser());
        this.getUserNameField().setText(this.connectionInfo.getAuthUser());
        this.getUserPasswordField().setText(this.connectionInfo.getAuthPassword());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getComponentPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getStatusPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JTabbedPane getComponentPanel() {
        if (this.componentPanel == null) {
            this.componentPanel = new JTabbedPane();
            this.componentPanel.setName("");
            this.componentPanel.addTab("Proxy", null, this.getProxy(), "Proxy information");
            this.componentPanel.addTab("Security", null, this.getSecurity(), "Security Information");
        }
        return this.componentPanel;
    }

    private JPanel getProxy() {
        if (this.proxy == null) {
            this.proxyPasswordLbl = new JLabel();
            this.proxyPasswordLbl.setText("Password");
            this.proxyUserNameLbl = new JLabel();
            this.proxyUserNameLbl.setText("User Name");
            this.proxyPortLbl = new JLabel();
            this.proxyPortLbl.setText("Port");
            this.proxyHostLbl = new JLabel();
            this.proxyHostLbl.setText("Host Name");
            this.proxy = new JPanel();
            this.proxy.setLayout(new DialogLayout());
            this.proxy.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.proxy.add((Component)this.proxyHostLbl, null);
            this.proxy.add((Component)this.getProxyHostField(), null);
            this.proxy.add((Component)this.proxyPortLbl, null);
            this.proxy.add((Component)this.getProxyPortField(), null);
            this.proxy.add((Component)this.proxyUserNameLbl, null);
            this.proxy.add((Component)this.getProxyUserField(), null);
            this.proxy.add((Component)this.proxyPasswordLbl, null);
            this.proxy.add((Component)this.getProxyPasswordField(), null);
        }
        return this.proxy;
    }

    private JPanel getSecurity() {
        if (this.security == null) {
            this.userPasswordLbl = new JLabel();
            this.userPasswordLbl.setText("Password");
            this.userNameLbl = new JLabel();
            this.userNameLbl.setText("User Name");
            this.security = new JPanel();
            this.security.setLayout(new DialogLayout());
            this.security.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.security.add((Component)this.userNameLbl, null);
            this.security.add((Component)this.getUserNameField(), null);
            this.security.add((Component)this.userPasswordLbl, null);
            this.security.add((Component)this.getUserPasswordField(), null);
        }
        return this.security;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setHgap(4);
            gridLayout.setColumns(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                    String field = OptionsDialog.this.getProxyPortField().getText();
                    if (field == null) {
                        ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyPort = 80;
                    } else {
                        try {
                            ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyPort = Integer.parseInt(OptionsDialog.this.getProxyPortField().getText().trim());
                        }
                        catch (NumberFormatException e1) {
                            e1.printStackTrace();
                            OptionsDialog.this.getStatusMsg().setText("Port should be numeric");
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    OptionsDialog.this.getProxyPortField().requestFocusInWindow();
                                }
                            });
                            return;
                        }
                    }
                    field = OptionsDialog.this.getProxyHostField().getText();
                    String string = field = field == null ? new String("") : field.trim();
                    if (field.compareTo("") != 0) {
                        if (!field.startsWith("http://") || !field.startsWith("https://")) {
                            field = "http://" + field;
                        }
                        try {
                            URL url = new URL(field);
                        }
                        catch (MalformedURLException e1) {
                            e1.printStackTrace();
                            OptionsDialog.this.getStatusMsg().setText("Incorrect URL for Proxy Host");
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    OptionsDialog.this.getProxyHostField().requestFocusInWindow();
                                }
                            });
                            return;
                        }
                    }
                    ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyHost = field;
                    int count = 0;
                    field = OptionsDialog.this.getProxyUserField().getText();
                    ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyUser = field == null ? new String("") : field.trim();
                    System.out.println("connectionInfo.proxyUser=" + ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyUser);
                    count = (short)(count + field.length());
                    System.out.println("count=" + count);
                    field = OptionsDialog.this.getProxyPasswordField().getText();
                    ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyPassword = field == null ? new String("") : field.trim();
                    System.out.println("connectionInfo.proxyPassword.length()=" + ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyPassword.length());
                    System.out.println("field.length()=" + field.length());
                    if (((OptionsDialog)OptionsDialog.this).connectionInfo.proxyUser.length() == 0 && field.length() != 0) {
                        OptionsDialog.this.getStatusMsg().setText("Please input Proxy User");
                        return;
                    }
                    count = (short)(count + field.length());
                    System.out.println("count=" + count);
                    field = OptionsDialog.this.getUserNameField().getText();
                    ((OptionsDialog)OptionsDialog.this).connectionInfo.authUser = field == null ? new String("") : field.trim();
                    System.out.println("connectionInfo.authUser.length()=" + ((OptionsDialog)OptionsDialog.this).connectionInfo.authUser.length());
                    System.out.println("count=" + count);
                    field = OptionsDialog.this.getUserPasswordField().getText();
                    ((OptionsDialog)OptionsDialog.this).connectionInfo.authPassword = field == null ? new String("") : field.trim();
                    System.out.println("connectionInfo.authPassword.length()=" + ((OptionsDialog)OptionsDialog.this).connectionInfo.authPassword.length());
                    System.out.println("connectionInfo.authUser.length()=" + ((OptionsDialog)OptionsDialog.this).connectionInfo.authUser.length());
                    if (((OptionsDialog)OptionsDialog.this).connectionInfo.authUser.length() == 0 && field.length() != 0) {
                        OptionsDialog.this.getStatusMsg().setText("Please input User Name for webserver");
                        return;
                    }
                    if (count > 0 && ((OptionsDialog)OptionsDialog.this).connectionInfo.proxyHost.length() == 0) {
                        OptionsDialog.this.getStatusMsg().setText("Please input proxy host");
                        return;
                    }
                    OptionsDialog.this.done = true;
                    OptionsDialog.this.connectionInfo.saveConfig();
                    OptionsDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            ActionListener lst = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                    OptionsDialog.this.dispose();
                }
            };
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(lst);
            this.getRootPane().registerKeyboardAction(lst, KeyStroke.getKeyStroke(27, 0), 2);
        }
        return this.cancelButton;
    }

    private JTextField getProxyHostField() {
        if (this.proxyHostField == null) {
            this.proxyHostField = new JTextField();
        }
        return this.proxyHostField;
    }

    private JTextField getProxyPortField() {
        if (this.proxyPortField == null) {
            this.proxyPortField = new JTextField();
            this.proxyPortField.setPreferredSize(new Dimension(60, 20));
            this.proxyPortField.setMinimumSize(new Dimension(60, 20));
        }
        return this.proxyPortField;
    }

    private JTextField getProxyUserField() {
        if (this.proxyUserField == null) {
            this.proxyUserField = new JTextField();
        }
        return this.proxyUserField;
    }

    private JTextField getProxyPasswordField() {
        if (this.proxyPasswordField == null) {
            this.proxyPasswordField = new JTextField();
        }
        return this.proxyPasswordField;
    }

    private JTextField getUserNameField() {
        if (this.userNameField == null) {
            this.userNameField = new JTextField();
        }
        return this.userNameField;
    }

    private JTextField getUserPasswordField() {
        if (this.userPasswordField == null) {
            this.userPasswordField = new JTextField();
        }
        return this.userPasswordField;
    }

    private JLabel getStatusMsg() {
        if (this.statusMsg == null) {
            this.statusMsg = new JLabel();
            this.statusMsg.setText("Text");
        }
        return this.statusMsg;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.statusPanel.add((Component)this.getStatusMsg(), "Center");
        }
        return this.statusPanel;
    }

    public static void main(String[] argv) {
        OptionsDialog d = new OptionsDialog(null);
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }
}

