/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.BreakIterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ResumeDialog
extends JDialog {
    public int result;
    private JCheckBox allCheckBox;
    public static final int RESUME_OPTION = -5000;
    public static final int OVERWRITE_OPTION = -5001;
    public static final int SKIP_OPTION = -5002;
    public static final int RESUME_ALL_OPTION = -5003;
    public static final int OVERWRITE_ALL_OPTION = -5004;
    public static final int SKIP_ALL_OPTION = -5005;

    public static void main(String[] args) {
        try {
            ResumeDialog dialog = new ResumeDialog(new Frame(), "", false);
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResumeDialog(Frame owner, String file, boolean resume) {
        super(owner, true);
        SkipButtonActionListener lst = new SkipButtonActionListener();
        this.getRootPane().registerKeyboardAction(lst, KeyStroke.getKeyStroke(27, 0), 2);
        String fileType = resume ? "Incomplete" : "Complete";
        this.setTitle("File Exists (" + fileType + ")");
        this.setBounds(100, 100, 543, 139);
        JPanel componentPanel = new JPanel();
        componentPanel.setLayout(new BorderLayout());
        componentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(componentPanel);
        JPanel buttonPanel = new JPanel();
        componentPanel.add((Component)buttonPanel, "South");
        if (resume) {
            JButton resumeButton = new JButton();
            resumeButton.addActionListener(new ResumeButtonActionListener());
            resumeButton.setText("Resume");
            buttonPanel.add(resumeButton);
        }
        JButton overWriteButton = new JButton();
        overWriteButton.addActionListener(new OverWriteButtonActionListener());
        overWriteButton.setText("Overwrite");
        buttonPanel.add(overWriteButton);
        JButton cancelButton = new JButton();
        cancelButton.addActionListener(lst);
        cancelButton.setText("Skip");
        buttonPanel.add(cancelButton);
        this.allCheckBox = new JCheckBox();
        this.allCheckBox.setText("Do this action for all " + fileType + " files");
        buttonPanel.add(this.allCheckBox);
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BorderLayout());
        componentPanel.add((Component)msgPanel, "Center");
        JLabel msgLabel = new JLabel("File " + file + " exists, action?");
        msgPanel.add((Component)msgLabel, "Center");
        JSeparator separator = new JSeparator();
        msgPanel.add((Component)separator, "South");
        this.setResizable(false);
    }

    private void wrapLabelText(JLabel label, String text) {
        FontMetrics fm = label.getFontMetrics(label.getFont());
        Container container = label.getParent();
        int containerWidth = container.getWidth();
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        StringBuffer trial = new StringBuffer();
        StringBuffer real = new StringBuffer("<html>");
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String word = text.substring(start, end);
            trial.append(word);
            int trialWidth = SwingUtilities.computeStringWidth(fm, trial.toString());
            if (trialWidth > containerWidth) {
                trial = new StringBuffer(word);
                real.append("<br>");
            }
            real.append(word);
            start = end;
            end = boundary.next();
        }
        real.append("</html>");
        label.setText(real.toString());
    }

    private class ResumeButtonActionListener
    implements ActionListener {
        private ResumeButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ResumeDialog.this.result = ResumeDialog.this.allCheckBox.isSelected() ? -5003 : -5000;
            ResumeDialog.this.dispose();
        }
    }

    private class OverWriteButtonActionListener
    implements ActionListener {
        private OverWriteButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ResumeDialog.this.result = ResumeDialog.this.allCheckBox.isSelected() ? -5004 : -5001;
            ResumeDialog.this.dispose();
        }
    }

    private class SkipButtonActionListener
    implements ActionListener {
        private SkipButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ResumeDialog.this.result = ResumeDialog.this.allCheckBox.isSelected() ? -5005 : -5002;
            ResumeDialog.this.dispose();
        }
    }
}

