/*
 * Decompiled with CFR 0.152.
 */
package com.fastream.iqwfserver;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadListModel
extends AbstractTableModel {
    private static final Log LOG = LogFactory.getLog(UploadListModel.class);
    protected Vector uploadList;
    protected transient Object dirIcon;
    protected transient Object fileIcon;
    protected Hashtable uploadDirectories;
    protected int totalFiles;

    public UploadListModel() {
        this.init();
    }

    public UploadListModel(File dir) {
        this.init();
    }

    protected void init() {
        this.uploadList = new Vector();
        this.dirIcon = UIManager.get("FileView.directoryIcon");
        this.fileIcon = UIManager.get("FileView.fileIcon");
    }

    public boolean addItem(int nRow, String item) {
        if (nRow < 0) {
            nRow = 0;
        }
        if (nRow > this.uploadList.size()) {
            nRow = this.uploadList.size();
        }
        if (this.uploadList.indexOf(item) != -1) {
            return false;
        }
        this.uploadList.insertElementAt(item, nRow);
        this.fireTableRowsInserted(nRow, nRow);
        return true;
    }

    public boolean removeItem(int nRow) {
        if (nRow < 0 || nRow >= this.uploadList.size()) {
            return false;
        }
        Object o = this.uploadList.remove(nRow);
        if (o != null) {
            File f = new File((String)o);
            if (f.isDirectory()) {
                if (this.uploadDirectories != null) {
                    this.uploadDirectories.remove((String)o);
                }
            } else if (this.uploadDirectories != null) {
                int index;
                List l;
                List list = l = this.uploadDirectories.containsKey("root") ? (List)this.uploadDirectories.get("root") : null;
                if (l != null && (index = l.indexOf((String)o)) != -1) {
                    l.remove(index);
                }
            }
        }
        this.fireTableRowsDeleted(nRow, nRow);
        return true;
    }

    public boolean removeItem(String item) {
        boolean result = false;
        if (this.uploadList.size() == 0) {
            return result;
        }
        int index = this.uploadList.indexOf(item);
        if (index != -1) {
            File f = new File((String)this.uploadList.remove(index));
            result = true;
            this.fireTableRowsDeleted(index, index);
        }
        return result;
    }

    public void removeAll() {
        this.uploadList.removeAllElements();
        this.uploadDirectories = null;
        this.fireTableDataChanged();
    }

    public String[] getAllItems() {
        if (this.uploadList.size() == 0) {
            return null;
        }
        Object[] ary = new String[this.uploadList.size()];
        this.uploadList.copyInto(ary);
        return ary;
    }

    public int getRowCount() {
        return this.uploadList != null ? this.uploadList.size() : 0;
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int column) {
        if (this.uploadList == null) {
            return null;
        }
        File fileSysEntity = new File((String)this.uploadList.get(row));
        switch (column) {
            case 0: {
                return fileSysEntity.isDirectory() ? this.dirIcon : this.fileIcon;
            }
            case 1: {
                return fileSysEntity.toString();
            }
            case 2: {
                if (fileSysEntity.isDirectory()) {
                    return "--";
                }
                return new Long(fileSysEntity.length());
            }
        }
        return "";
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Bytes";
            }
        }
        return "unknown";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return this.getValueAt(0, column).getClass();
        }
        return super.getColumnClass(column);
    }

    public boolean loadQueue(File f) {
        try {
            FileReader reader = new FileReader(f);
            ObjectInputStream ois = new XStream().createObjectInputStream((Reader)reader);
            this.uploadList = (Vector)ois.readObject();
            this.uploadDirectories = (Hashtable)ois.readObject();
            if (this.uploadDirectories.isEmpty()) {
                this.uploadDirectories = null;
            }
            this.totalFiles = ois.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.fireTableDataChanged();
        return true;
    }

    public boolean saveQueue(String remoteHost) {
        try {
            FileWriter writer = new FileWriter(String.valueOf(System.getProperty("user.home")) + File.separatorChar + this.makeQueueFile(remoteHost));
            ObjectOutputStream oos = new XStream().createObjectOutputStream((Writer)writer);
            int count = 0;
            if (this.uploadDirectories != null) {
                Enumeration keys = this.uploadDirectories.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("root")) continue;
                    List l = (List)this.uploadDirectories.get(key);
                    count += l.size();
                }
                count += this.uploadList.size();
            } else {
                count = this.uploadList.size();
            }
            this.totalFiles = count;
            oos.writeObject(this.uploadList);
            if (this.uploadDirectories == null) {
                oos.writeObject(new Hashtable());
            } else {
                oos.writeObject(this.uploadDirectories);
            }
            oos.writeInt(this.totalFiles);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String makeQueueFile(String remoteHost) {
        URL url;
        LOG.debug((Object)("remoteHost is = " + remoteHost));
        try {
            url = new URL(remoteHost);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "dd.MM.yyy_HH.mm.ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        String fileName = String.valueOf(url.getHost()) + "_" + port + "_" + sdf.format(cal.getTime()) + ".iqw";
        return fileName;
    }
}

